﻿#If
/*
;;; ============================================================================
;;; 同時に打鍵する配列だが、
;;; 真に同時に打鍵する配列ではないとき
;;; ============================================================================

#If (( mod_key[window_title, "_hoge"] 
		and !( true_mod_key[window_title, "_hoge"] ) ))
    scancode::
            onKeyDown("_hoge")

    return


;;; ============================================================================
;;; 真に同時に打鍵する配列のとき
;;; ============================================================================

#If ( true_mod_key[window_title, "_hoge"] )
	scancode up::
		;; up を取り除く
	    key_up("hoge", A_TickCount)
	    return


	scancode::
		;; 真に同時に打鍵するキーのリスト
		key_down("hoge", A_TickCount, true_mod_key[window_title, "_hoge"])
	    return


*/



/*
;;; ============================================================================
;;; 同時に打鍵する配列だが、
;;; 真に同時に打鍵する配列ではないとき
;;; ============================================================================

#If (( mod_key[window_title, "_shift"] 
		and !( true_mod_key[window_title, "_shift"] ) ))
    Shift::
            onKeyDown("_shift")

    return


;;; ============================================================================
;;; 真に同時に打鍵する配列のとき
;;; ============================================================================

#If ( true_mod_key[window_title, "_shift"] )
	Shift up::
		;; up を取り除く
	    key_up("shift", A_TickCount)
	    return


	Shift::
		;; 真に同時に打鍵するキーのリスト
		key_down("shift", A_TickCount, true_mod_key[window_title, "_shift"])
	    return
*/



;;; ============================================================================
;;; ---------------- [Shift] を 同時打鍵のキーとして使用する
;;; ============================================================================

#If ( mod_key[window_title, "_shift"] )
    Shift::


        If ( true_mod_key[window_title, "_shift"] ) {
            onKeyDown("_shift")
        } else {
            onKeyDown("_shift")
        }
    return


;;; ============================================================================
;;; ---------------- [Shift] をそのまま使用する
;;; ============================================================================

#If
    +sc002::
    +sc003::
    +sc004::
    +sc005::
    +sc006::
    +sc007::
    +sc008::
    +sc009::
    +sc00A::
    +sc00B::
    +sc00C::
    +sc00D::
    +sc07D::
    +sc010::
    +sc011::
    +sc012::
    +sc013::
    +sc014::
    +sc015::
    +sc016::
    +sc017::
    +sc018::
    +sc019::
    +sc01A::
    +sc01B::
    +sc01E::
    +sc01F::
    +sc020::
    +sc021::
    +sc022::
    +sc023::
    +sc024::
    +sc025::
    +sc026::
    +sc027::
    +sc028::
    +sc02B::
    +sc02C::
    +sc02D::
    +sc02E::
    +sc02F::
    +sc030::
    +sc031::
    +sc032::
    +sc033::
    +sc034::
    +sc035::
    +sc073::


        if ( GetOutputLang() = "en" )
            GoSub, Send_EnglishLayout_shift
        else
            GoSub, Send_JapaneseLayout_shift
    return
